package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Authentication;
import odata.msgraph.client.beta.entity.collection.request.AuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EmailAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.Fido2AuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.LongRunningOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MicrosoftAuthenticatorAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PasswordAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PasswordlessMicrosoftAuthenticatorAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PhoneAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SoftwareOathAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TemporaryAccessPassAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsHelloForBusinessAuthenticationMethodCollectionRequest;

@JsonIgnoreType
public class AuthenticationRequest extends EntityRequest<Authentication> {

    public AuthenticationRequest(ContextPath contextPath, Optional<Object> value) {
        super(Authentication.class, contextPath, value, false);
    }

    public EmailAuthenticationMethodRequest emailMethods(String id) {
        return new EmailAuthenticationMethodRequest(contextPath.addSegment("emailMethods").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EmailAuthenticationMethodCollectionRequest emailMethods() {
        return new EmailAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("emailMethods"), Optional.empty());
    }

    public Fido2AuthenticationMethodRequest fido2Methods(String id) {
        return new Fido2AuthenticationMethodRequest(contextPath.addSegment("fido2Methods").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public Fido2AuthenticationMethodCollectionRequest fido2Methods() {
        return new Fido2AuthenticationMethodCollectionRequest(
                        contextPath.addSegment("fido2Methods"), Optional.empty());
    }

    public AuthenticationMethodRequest methods(String id) {
        return new AuthenticationMethodRequest(contextPath.addSegment("methods").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AuthenticationMethodCollectionRequest methods() {
        return new AuthenticationMethodCollectionRequest(
                        contextPath.addSegment("methods"), Optional.empty());
    }

    public MicrosoftAuthenticatorAuthenticationMethodRequest microsoftAuthenticatorMethods(String id) {
        return new MicrosoftAuthenticatorAuthenticationMethodRequest(contextPath.addSegment("microsoftAuthenticatorMethods").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MicrosoftAuthenticatorAuthenticationMethodCollectionRequest microsoftAuthenticatorMethods() {
        return new MicrosoftAuthenticatorAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("microsoftAuthenticatorMethods"), Optional.empty());
    }

    public LongRunningOperationRequest operations(String id) {
        return new LongRunningOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public LongRunningOperationCollectionRequest operations() {
        return new LongRunningOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.empty());
    }

    public PasswordlessMicrosoftAuthenticatorAuthenticationMethodRequest passwordlessMicrosoftAuthenticatorMethods(String id) {
        return new PasswordlessMicrosoftAuthenticatorAuthenticationMethodRequest(contextPath.addSegment("passwordlessMicrosoftAuthenticatorMethods").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PasswordlessMicrosoftAuthenticatorAuthenticationMethodCollectionRequest passwordlessMicrosoftAuthenticatorMethods() {
        return new PasswordlessMicrosoftAuthenticatorAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("passwordlessMicrosoftAuthenticatorMethods"), Optional.empty());
    }

    public PasswordAuthenticationMethodRequest passwordMethods(String id) {
        return new PasswordAuthenticationMethodRequest(contextPath.addSegment("passwordMethods").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PasswordAuthenticationMethodCollectionRequest passwordMethods() {
        return new PasswordAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("passwordMethods"), Optional.empty());
    }

    public PhoneAuthenticationMethodRequest phoneMethods(String id) {
        return new PhoneAuthenticationMethodRequest(contextPath.addSegment("phoneMethods").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PhoneAuthenticationMethodCollectionRequest phoneMethods() {
        return new PhoneAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("phoneMethods"), Optional.empty());
    }

    public SoftwareOathAuthenticationMethodRequest softwareOathMethods(String id) {
        return new SoftwareOathAuthenticationMethodRequest(contextPath.addSegment("softwareOathMethods").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SoftwareOathAuthenticationMethodCollectionRequest softwareOathMethods() {
        return new SoftwareOathAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("softwareOathMethods"), Optional.empty());
    }

    public TemporaryAccessPassAuthenticationMethodRequest temporaryAccessPassMethods(String id) {
        return new TemporaryAccessPassAuthenticationMethodRequest(contextPath.addSegment("temporaryAccessPassMethods").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TemporaryAccessPassAuthenticationMethodCollectionRequest temporaryAccessPassMethods() {
        return new TemporaryAccessPassAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("temporaryAccessPassMethods"), Optional.empty());
    }

    public WindowsHelloForBusinessAuthenticationMethodRequest windowsHelloForBusinessMethods(String id) {
        return new WindowsHelloForBusinessAuthenticationMethodRequest(contextPath.addSegment("windowsHelloForBusinessMethods").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsHelloForBusinessAuthenticationMethodCollectionRequest windowsHelloForBusinessMethods() {
        return new WindowsHelloForBusinessAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("windowsHelloForBusinessMethods"), Optional.empty());
    }

}
