package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.UserRegistrationFeatureSummary;
import odata.msgraph.client.beta.complex.UserRegistrationMethodSummary;
import odata.msgraph.client.beta.entity.AuthenticationMethodsRoot;
import odata.msgraph.client.beta.entity.collection.request.UserRegistrationDetailsCollectionRequest;
import odata.msgraph.client.beta.enums.IncludedUserRoles;
import odata.msgraph.client.beta.enums.IncludedUserTypes;

@JsonIgnoreType
public class AuthenticationMethodsRootRequest extends EntityRequest<AuthenticationMethodsRoot> {

    public AuthenticationMethodsRootRequest(ContextPath contextPath, Optional<Object> value) {
        super(AuthenticationMethodsRoot.class, contextPath, value, false);
    }

    public UserRegistrationDetailsRequest userRegistrationDetails(String id) {
        return new UserRegistrationDetailsRequest(contextPath.addSegment("userRegistrationDetails").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserRegistrationDetailsCollectionRequest userRegistrationDetails() {
        return new UserRegistrationDetailsCollectionRequest(
                        contextPath.addSegment("userRegistrationDetails"), Optional.empty());
    }

    @Function(name = "usersRegisteredByFeature")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<UserRegistrationFeatureSummary> usersRegisteredByFeature() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<UserRegistrationFeatureSummary>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.usersRegisteredByFeature"), UserRegistrationFeatureSummary.class, _parameters);
    }

    @Function(name = "usersRegisteredByFeature")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<UserRegistrationFeatureSummary> usersRegisteredByFeature_Function(IncludedUserTypes includedUserTypes, IncludedUserRoles includedUserRoles) {
        Preconditions.checkNotNull(includedUserTypes, "includedUserTypes cannot be null");
        Preconditions.checkNotNull(includedUserRoles, "includedUserRoles cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("includedUserTypes", "microsoft.graph.includedUserTypes", includedUserTypes)
            .put("includedUserRoles", "microsoft.graph.includedUserRoles", includedUserRoles)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<UserRegistrationFeatureSummary>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.usersRegisteredByFeature"), UserRegistrationFeatureSummary.class, _parameters);
    }

    @Function(name = "usersRegisteredByMethod")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<UserRegistrationMethodSummary> usersRegisteredByMethod() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<UserRegistrationMethodSummary>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.usersRegisteredByMethod"), UserRegistrationMethodSummary.class, _parameters);
    }

    @Function(name = "usersRegisteredByMethod")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<UserRegistrationMethodSummary> usersRegisteredByMethod_Function(IncludedUserTypes includedUserTypes, IncludedUserRoles includedUserRoles) {
        Preconditions.checkNotNull(includedUserTypes, "includedUserTypes cannot be null");
        Preconditions.checkNotNull(includedUserRoles, "includedUserRoles cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("includedUserTypes", "microsoft.graph.includedUserTypes", includedUserTypes)
            .put("includedUserRoles", "microsoft.graph.includedUserRoles", includedUserRoles)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<UserRegistrationMethodSummary>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.usersRegisteredByMethod"), UserRegistrationMethodSummary.class, _parameters);
    }

}
