package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.PasswordResetResponse;
import odata.msgraph.client.beta.entity.AuthenticationMethod;

@JsonIgnoreType
public class AuthenticationMethodRequest extends EntityRequest<AuthenticationMethod> {

    public AuthenticationMethodRequest(ContextPath contextPath, Optional<Object> value) {
        super(AuthenticationMethod.class, contextPath, value, false);
    }

    @Action(name = "disableSmsSignIn")
    @JsonIgnore
    public ActionRequestNoReturn disableSmsSignIn() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.disableSmsSignIn"), _parameters);
    }

    @Action(name = "enableSmsSignIn")
    @JsonIgnore
    public ActionRequestNoReturn enableSmsSignIn() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.enableSmsSignIn"), _parameters);
    }

    @Action(name = "resetPassword")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PasswordResetResponse> resetPassword(String newPassword, Boolean requireChangeOnNextSignIn) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("newPassword", "Edm.String", Checks.checkIsAscii(newPassword))
            .put("requireChangeOnNextSignIn", "Edm.Boolean", requireChangeOnNextSignIn)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PasswordResetResponse>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.resetPassword"), PasswordResetResponse.class, _parameters);
    }

}
