package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AuthenticationEventsPolicy;
import odata.msgraph.client.beta.entity.collection.request.AuthenticationListenerCollectionRequest;

@JsonIgnoreType
public class AuthenticationEventsPolicyRequest extends EntityRequest<AuthenticationEventsPolicy> {

    public AuthenticationEventsPolicyRequest(ContextPath contextPath, Optional<Object> value) {
        super(AuthenticationEventsPolicy.class, contextPath, value, false);
    }

    public AuthenticationListenerRequest onSignupStart(String id) {
        return new AuthenticationListenerRequest(contextPath.addSegment("onSignupStart").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AuthenticationListenerCollectionRequest onSignupStart() {
        return new AuthenticationListenerCollectionRequest(
                        contextPath.addSegment("onSignupStart"), Optional.empty());
    }

}
