package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Approval;
import odata.msgraph.client.beta.entity.collection.request.ApprovalStepCollectionRequest;

@JsonIgnoreType
public class ApprovalRequest extends EntityRequest<Approval> {

    public ApprovalRequest(ContextPath contextPath, Optional<Object> value) {
        super(Approval.class, contextPath, value, false);
    }

    public RequestRequest request() {
        return new RequestRequest(contextPath.addSegment("request"), Optional.empty());
    }

    public ApprovalStepRequest steps(String id) {
        return new ApprovalStepRequest(contextPath.addSegment("steps").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ApprovalStepCollectionRequest steps() {
        return new ApprovalStepCollectionRequest(
                        contextPath.addSegment("steps"), Optional.empty());
    }

}
