package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.complex.KeyCredential;
import odata.msgraph.client.beta.complex.PasswordCredential;
import odata.msgraph.client.beta.entity.Application;
import odata.msgraph.client.beta.entity.collection.request.AppManagementPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.FederatedIdentityCredentialCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.HomeRealmDiscoveryPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TokenIssuancePolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TokenLifetimePolicyCollectionRequest;

@JsonIgnoreType
public class ApplicationRequest extends EntityRequest<Application> {

    public ApplicationRequest(ContextPath contextPath, Optional<Object> value) {
        super(Application.class, contextPath, value, true);
    }

    public AppManagementPolicyRequest appManagementPolicies(String id) {
        return new AppManagementPolicyRequest(contextPath.addSegment("appManagementPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AppManagementPolicyCollectionRequest appManagementPolicies() {
        return new AppManagementPolicyCollectionRequest(
                        contextPath.addSegment("appManagementPolicies"), Optional.empty());
    }

    public DirectoryObjectRequest createdOnBehalfOf() {
        return new DirectoryObjectRequest(contextPath.addSegment("createdOnBehalfOf"), Optional.empty());
    }

    public ExtensionPropertyRequest extensionProperties(String id) {
        return new ExtensionPropertyRequest(contextPath.addSegment("extensionProperties").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExtensionPropertyCollectionRequest extensionProperties() {
        return new ExtensionPropertyCollectionRequest(
                        contextPath.addSegment("extensionProperties"), Optional.empty());
    }

    public FederatedIdentityCredentialRequest federatedIdentityCredentials(String id) {
        return new FederatedIdentityCredentialRequest(contextPath.addSegment("federatedIdentityCredentials").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public FederatedIdentityCredentialCollectionRequest federatedIdentityCredentials() {
        return new FederatedIdentityCredentialCollectionRequest(
                        contextPath.addSegment("federatedIdentityCredentials"), Optional.empty());
    }

    public HomeRealmDiscoveryPolicyRequest homeRealmDiscoveryPolicies(String id) {
        return new HomeRealmDiscoveryPolicyRequest(contextPath.addSegment("homeRealmDiscoveryPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public HomeRealmDiscoveryPolicyCollectionRequest homeRealmDiscoveryPolicies() {
        return new HomeRealmDiscoveryPolicyCollectionRequest(
                        contextPath.addSegment("homeRealmDiscoveryPolicies"), Optional.empty());
    }

    public DirectoryObjectRequest owners(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("owners").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest owners() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("owners"), Optional.empty());
    }

    public TokenIssuancePolicyRequest tokenIssuancePolicies(String id) {
        return new TokenIssuancePolicyRequest(contextPath.addSegment("tokenIssuancePolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TokenIssuancePolicyCollectionRequest tokenIssuancePolicies() {
        return new TokenIssuancePolicyCollectionRequest(
                        contextPath.addSegment("tokenIssuancePolicies"), Optional.empty());
    }

    public TokenLifetimePolicyRequest tokenLifetimePolicies(String id) {
        return new TokenLifetimePolicyRequest(contextPath.addSegment("tokenLifetimePolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TokenLifetimePolicyCollectionRequest tokenLifetimePolicies() {
        return new TokenLifetimePolicyCollectionRequest(
                        contextPath.addSegment("tokenLifetimePolicies"), Optional.empty());
    }

    public ConnectorGroupRequest connectorGroup() {
        return new ConnectorGroupRequest(contextPath.addSegment("connectorGroup"), Optional.empty());
    }

    public SynchronizationRequest synchronization() {
        return new SynchronizationRequest(contextPath.addSegment("synchronization"), Optional.empty());
    }

    @Action(name = "setVerifiedPublisher")
    @JsonIgnore
    public ActionRequestNoReturn setVerifiedPublisher(String verifiedPublisherId) {
        Preconditions.checkNotNull(verifiedPublisherId, "verifiedPublisherId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("verifiedPublisherId", "Edm.String", Checks.checkIsAscii(verifiedPublisherId))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setVerifiedPublisher"), _parameters);
    }

    @Action(name = "unsetVerifiedPublisher")
    @JsonIgnore
    public ActionRequestNoReturn unsetVerifiedPublisher() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unsetVerifiedPublisher"), _parameters);
    }

    @Action(name = "addKey")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<KeyCredential> addKey(KeyCredential keyCredential, PasswordCredential passwordCredential, String proof) {
        Preconditions.checkNotNull(keyCredential, "keyCredential cannot be null");
        Preconditions.checkNotNull(proof, "proof cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("keyCredential", "microsoft.graph.keyCredential", keyCredential)
            .put("passwordCredential", "microsoft.graph.passwordCredential", passwordCredential)
            .put("proof", "Edm.String", Checks.checkIsAscii(proof))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<KeyCredential>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.addKey"), KeyCredential.class, _parameters);
    }

    @Action(name = "addPassword")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PasswordCredential> addPassword(PasswordCredential passwordCredential) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("passwordCredential", "microsoft.graph.passwordCredential", passwordCredential)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PasswordCredential>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.addPassword"), PasswordCredential.class, _parameters);
    }

    @Action(name = "removeKey")
    @JsonIgnore
    public ActionRequestNoReturn removeKey(UUID keyId, String proof) {
        Preconditions.checkNotNull(keyId, "keyId cannot be null");
        Preconditions.checkNotNull(proof, "proof cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("keyId", "Edm.Guid", keyId)
            .put("proof", "Edm.String", Checks.checkIsAscii(proof))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.removeKey"), _parameters);
    }

    @Action(name = "removePassword")
    @JsonIgnore
    public ActionRequestNoReturn removePassword(UUID keyId) {
        Preconditions.checkNotNull(keyId, "keyId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("keyId", "Edm.Guid", keyId)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.removePassword"), _parameters);
    }

}
