package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AndroidEnterpriseWiFiConfiguration;

@JsonIgnoreType
public class AndroidEnterpriseWiFiConfigurationRequest extends EntityRequest<AndroidEnterpriseWiFiConfiguration> {

    public AndroidEnterpriseWiFiConfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(AndroidEnterpriseWiFiConfiguration.class, contextPath, value, false);
    }

    public AndroidCertificateProfileBaseRequest identityCertificateForClientAuthentication() {
        return new AndroidCertificateProfileBaseRequest(contextPath.addSegment("identityCertificateForClientAuthentication"), Optional.empty());
    }

    public AndroidTrustedRootCertificateRequest rootCertificateForServerValidation() {
        return new AndroidTrustedRootCertificateRequest(contextPath.addSegment("rootCertificateForServerValidation"), Optional.empty());
    }

}
