package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AndroidDeviceOwnerPkcsCertificateProfile;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceCertificateStateCollectionRequest;

@JsonIgnoreType
public class AndroidDeviceOwnerPkcsCertificateProfileRequest extends EntityRequest<AndroidDeviceOwnerPkcsCertificateProfile> {

    public AndroidDeviceOwnerPkcsCertificateProfileRequest(ContextPath contextPath, Optional<Object> value) {
        super(AndroidDeviceOwnerPkcsCertificateProfile.class, contextPath, value, false);
    }

    public ManagedDeviceCertificateStateRequest managedDeviceCertificateStates(String id) {
        return new ManagedDeviceCertificateStateRequest(contextPath.addSegment("managedDeviceCertificateStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedDeviceCertificateStateCollectionRequest managedDeviceCertificateStates() {
        return new ManagedDeviceCertificateStateCollectionRequest(
                        contextPath.addSegment("managedDeviceCertificateStates"), Optional.empty());
    }

}
