package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AgreementFileLocalization;
import odata.msgraph.client.beta.entity.collection.request.AgreementFileVersionCollectionRequest;

@JsonIgnoreType
public class AgreementFileLocalizationRequest extends EntityRequest<AgreementFileLocalization> {

    public AgreementFileLocalizationRequest(ContextPath contextPath, Optional<Object> value) {
        super(AgreementFileLocalization.class, contextPath, value, false);
    }

    public AgreementFileVersionRequest versions(String id) {
        return new AgreementFileVersionRequest(contextPath.addSegment("versions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AgreementFileVersionCollectionRequest versions() {
        return new AgreementFileVersionCollectionRequest(
                        contextPath.addSegment("versions"), Optional.empty());
    }

}
