package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AdministrativeUnit;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ScopedRoleMembershipCollectionRequest;

@JsonIgnoreType
public class AdministrativeUnitRequest extends EntityRequest<AdministrativeUnit> {

    public AdministrativeUnitRequest(ContextPath contextPath, Optional<Object> value) {
        super(AdministrativeUnit.class, contextPath, value, false);
    }

    public DirectoryObjectRequest members(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("members").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest members() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("members"), Optional.empty());
    }

    public ScopedRoleMembershipRequest scopedRoleMembers(String id) {
        return new ScopedRoleMembershipRequest(contextPath.addSegment("scopedRoleMembers").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ScopedRoleMembershipCollectionRequest scopedRoleMembers() {
        return new ScopedRoleMembershipCollectionRequest(
                        contextPath.addSegment("scopedRoleMembers"), Optional.empty());
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"), Optional.empty());
    }

}
