package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Admin;
import odata.msgraph.client.beta.windows.updates.entity.request.WindowsRequest;

@JsonIgnoreType
public class AdminRequest extends EntityRequest<Admin> {

    public AdminRequest(ContextPath contextPath, Optional<Object> value) {
        super(Admin.class, contextPath, value, false);
    }

    public ServiceAnnouncementRequest serviceAnnouncement() {
        return new ServiceAnnouncementRequest(contextPath.addSegment("serviceAnnouncement"), Optional.empty());
    }

    public WindowsRequest windows() {
        return new WindowsRequest(contextPath.addSegment("windows"), Optional.empty());
    }

}
