package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessReviewSet;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewHistoryDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewInstanceDecisionItemCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewScheduleDefinitionCollectionRequest;

@JsonIgnoreType
public class AccessReviewSetRequest extends EntityRequest<AccessReviewSet> {

    public AccessReviewSetRequest(ContextPath contextPath, Optional<Object> value) {
        super(AccessReviewSet.class, contextPath, value, false);
    }

    public AccessReviewInstanceDecisionItemRequest decisions(String id) {
        return new AccessReviewInstanceDecisionItemRequest(contextPath.addSegment("decisions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviewInstanceDecisionItemCollectionRequest decisions() {
        return new AccessReviewInstanceDecisionItemCollectionRequest(
                        contextPath.addSegment("decisions"), Optional.empty());
    }

    public AccessReviewScheduleDefinitionRequest definitions(String id) {
        return new AccessReviewScheduleDefinitionRequest(contextPath.addSegment("definitions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviewScheduleDefinitionCollectionRequest definitions() {
        return new AccessReviewScheduleDefinitionCollectionRequest(
                        contextPath.addSegment("definitions"), Optional.empty());
    }

    public AccessReviewHistoryDefinitionRequest historyDefinitions(String id) {
        return new AccessReviewHistoryDefinitionRequest(contextPath.addSegment("historyDefinitions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviewHistoryDefinitionCollectionRequest historyDefinitions() {
        return new AccessReviewHistoryDefinitionCollectionRequest(
                        contextPath.addSegment("historyDefinitions"), Optional.empty());
    }

    public AccessReviewPolicyRequest policy() {
        return new AccessReviewPolicyRequest(contextPath.addSegment("policy"), Optional.empty());
    }

}
