package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessReview;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewDecisionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewReviewerCollectionRequest;

@JsonIgnoreType
public class AccessReviewRequest extends EntityRequest<AccessReview> {

    public AccessReviewRequest(ContextPath contextPath, Optional<Object> value) {
        super(AccessReview.class, contextPath, value, false);
    }

    public AccessReviewDecisionRequest decisions(String id) {
        return new AccessReviewDecisionRequest(contextPath.addSegment("decisions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviewDecisionCollectionRequest decisions() {
        return new AccessReviewDecisionCollectionRequest(
                        contextPath.addSegment("decisions"), Optional.empty());
    }

    public AccessReviewRequest instances(String id) {
        return new AccessReviewRequest(contextPath.addSegment("instances").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviewCollectionRequest instances() {
        return new AccessReviewCollectionRequest(
                        contextPath.addSegment("instances"), Optional.empty());
    }

    public AccessReviewDecisionRequest myDecisions(String id) {
        return new AccessReviewDecisionRequest(contextPath.addSegment("myDecisions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviewDecisionCollectionRequest myDecisions() {
        return new AccessReviewDecisionCollectionRequest(
                        contextPath.addSegment("myDecisions"), Optional.empty());
    }

    public AccessReviewReviewerRequest reviewers(String id) {
        return new AccessReviewReviewerRequest(contextPath.addSegment("reviewers").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviewReviewerCollectionRequest reviewers() {
        return new AccessReviewReviewerCollectionRequest(
                        contextPath.addSegment("reviewers"), Optional.empty());
    }

    @Action(name = "stop")
    @JsonIgnore
    public ActionRequestNoReturn stop() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.stop"), _parameters);
    }

    @Action(name = "applyDecisions")
    @JsonIgnore
    public ActionRequestNoReturn applyDecisions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyDecisions"), _parameters);
    }

    @Action(name = "resetDecisions")
    @JsonIgnore
    public ActionRequestNoReturn resetDecisions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.resetDecisions"), _parameters);
    }

    @Action(name = "sendReminder")
    @JsonIgnore
    public ActionRequestNoReturn sendReminder() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendReminder"), _parameters);
    }

}
