package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessReviewInstanceDecisionItem;
import odata.msgraph.client.beta.entity.collection.request.GovernanceInsightCollectionRequest;

@JsonIgnoreType
public class AccessReviewInstanceDecisionItemRequest extends EntityRequest<AccessReviewInstanceDecisionItem> {

    public AccessReviewInstanceDecisionItemRequest(ContextPath contextPath, Optional<Object> value) {
        super(AccessReviewInstanceDecisionItem.class, contextPath, value, false);
    }

    public GovernanceInsightRequest insights(String id) {
        return new GovernanceInsightRequest(contextPath.addSegment("insights").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GovernanceInsightCollectionRequest insights() {
        return new GovernanceInsightCollectionRequest(
                        contextPath.addSegment("insights"), Optional.empty());
    }

    public AccessReviewInstanceRequest instance() {
        return new AccessReviewInstanceRequest(contextPath.addSegment("instance"), Optional.empty());
    }

}
