package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessReviewHistoryInstance;

@JsonIgnoreType
public class AccessReviewHistoryInstanceRequest extends EntityRequest<AccessReviewHistoryInstance> {

    public AccessReviewHistoryInstanceRequest(ContextPath contextPath, Optional<Object> value) {
        super(AccessReviewHistoryInstance.class, contextPath, value, false);
    }

    @Action(name = "generateDownloadUri")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<AccessReviewHistoryInstance> generateDownloadUri() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<AccessReviewHistoryInstance>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.generateDownloadUri"), AccessReviewHistoryInstance.class, _parameters);
    }

}
