package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessPackageResourceRoleScope;

@JsonIgnoreType
public class AccessPackageResourceRoleScopeRequest extends EntityRequest<AccessPackageResourceRoleScope> {

    public AccessPackageResourceRoleScopeRequest(ContextPath contextPath, Optional<Object> value) {
        super(AccessPackageResourceRoleScope.class, contextPath, value, false);
    }

    public AccessPackageResourceRoleRequest accessPackageResourceRole() {
        return new AccessPackageResourceRoleRequest(contextPath.addSegment("accessPackageResourceRole"), Optional.empty());
    }

    public AccessPackageResourceScopeRequest accessPackageResourceScope() {
        return new AccessPackageResourceScopeRequest(contextPath.addSegment("accessPackageResourceScope"), Optional.empty());
    }

}
