package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessPackageResource;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceRoleCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceScopeCollectionRequest;

@JsonIgnoreType
public class AccessPackageResourceRequest extends EntityRequest<AccessPackageResource> {

    public AccessPackageResourceRequest(ContextPath contextPath, Optional<Object> value) {
        super(AccessPackageResource.class, contextPath, value, false);
    }

    public AccessPackageResourceEnvironmentRequest accessPackageResourceEnvironment() {
        return new AccessPackageResourceEnvironmentRequest(contextPath.addSegment("accessPackageResourceEnvironment"), Optional.empty());
    }

    public AccessPackageResourceRoleRequest accessPackageResourceRoles(String id) {
        return new AccessPackageResourceRoleRequest(contextPath.addSegment("accessPackageResourceRoles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageResourceRoleCollectionRequest accessPackageResourceRoles() {
        return new AccessPackageResourceRoleCollectionRequest(
                        contextPath.addSegment("accessPackageResourceRoles"), Optional.empty());
    }

    public AccessPackageResourceScopeRequest accessPackageResourceScopes(String id) {
        return new AccessPackageResourceScopeRequest(contextPath.addSegment("accessPackageResourceScopes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageResourceScopeCollectionRequest accessPackageResourceScopes() {
        return new AccessPackageResourceScopeCollectionRequest(
                        contextPath.addSegment("accessPackageResourceScopes"), Optional.empty());
    }

}
