package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessPackageResourceEnvironment;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceCollectionRequest;

@JsonIgnoreType
public class AccessPackageResourceEnvironmentRequest extends EntityRequest<AccessPackageResourceEnvironment> {

    public AccessPackageResourceEnvironmentRequest(ContextPath contextPath, Optional<Object> value) {
        super(AccessPackageResourceEnvironment.class, contextPath, value, false);
    }

    public AccessPackageResourceRequest accessPackageResources(String id) {
        return new AccessPackageResourceRequest(contextPath.addSegment("accessPackageResources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageResourceCollectionRequest accessPackageResources() {
        return new AccessPackageResourceCollectionRequest(
                        contextPath.addSegment("accessPackageResources"), Optional.empty());
    }

}
