package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AccessPackageAssignmentRequestRequirements;
import odata.msgraph.client.beta.entity.AccessPackage;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceRoleScopeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupCollectionRequest;

@JsonIgnoreType
public class AccessPackageRequest extends EntityRequest<AccessPackage> {

    public AccessPackageRequest(ContextPath contextPath, Optional<Object> value) {
        super(AccessPackage.class, contextPath, value, false);
    }

    public AccessPackageAssignmentPolicyRequest accessPackageAssignmentPolicies(String id) {
        return new AccessPackageAssignmentPolicyRequest(contextPath.addSegment("accessPackageAssignmentPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageAssignmentPolicyCollectionRequest accessPackageAssignmentPolicies() {
        return new AccessPackageAssignmentPolicyCollectionRequest(
                        contextPath.addSegment("accessPackageAssignmentPolicies"), Optional.empty());
    }

    public AccessPackageCatalogRequest accessPackageCatalog() {
        return new AccessPackageCatalogRequest(contextPath.addSegment("accessPackageCatalog"), Optional.empty());
    }

    public AccessPackageResourceRoleScopeRequest accessPackageResourceRoleScopes(String id) {
        return new AccessPackageResourceRoleScopeRequest(contextPath.addSegment("accessPackageResourceRoleScopes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageResourceRoleScopeCollectionRequest accessPackageResourceRoleScopes() {
        return new AccessPackageResourceRoleScopeCollectionRequest(
                        contextPath.addSegment("accessPackageResourceRoleScopes"), Optional.empty());
    }

    public AccessPackageRequest accessPackagesIncompatibleWith(String id) {
        return new AccessPackageRequest(contextPath.addSegment("accessPackagesIncompatibleWith").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageCollectionRequest accessPackagesIncompatibleWith() {
        return new AccessPackageCollectionRequest(
                        contextPath.addSegment("accessPackagesIncompatibleWith"), Optional.empty());
    }

    public AccessPackageRequest incompatibleAccessPackages(String id) {
        return new AccessPackageRequest(contextPath.addSegment("incompatibleAccessPackages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageCollectionRequest incompatibleAccessPackages() {
        return new AccessPackageCollectionRequest(
                        contextPath.addSegment("incompatibleAccessPackages"), Optional.empty());
    }

    public GroupRequest incompatibleGroups(String id) {
        return new GroupRequest(contextPath.addSegment("incompatibleGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupCollectionRequest incompatibleGroups() {
        return new GroupCollectionRequest(
                        contextPath.addSegment("incompatibleGroups"), Optional.empty());
    }

    @Action(name = "getApplicablePolicyRequirements")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AccessPackageAssignmentRequestRequirements> getApplicablePolicyRequirements() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getApplicablePolicyRequirements"), AccessPackageAssignmentRequestRequirements.class, _parameters);
    }

}
