package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessPackageCatalog;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceRoleCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceScopeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CustomAccessPackageWorkflowExtensionCollectionRequest;

@JsonIgnoreType
public class AccessPackageCatalogRequest extends EntityRequest<AccessPackageCatalog> {

    public AccessPackageCatalogRequest(ContextPath contextPath, Optional<Object> value) {
        super(AccessPackageCatalog.class, contextPath, value, false);
    }

    public AccessPackageResourceRoleRequest accessPackageResourceRoles(String id) {
        return new AccessPackageResourceRoleRequest(contextPath.addSegment("accessPackageResourceRoles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageResourceRoleCollectionRequest accessPackageResourceRoles() {
        return new AccessPackageResourceRoleCollectionRequest(
                        contextPath.addSegment("accessPackageResourceRoles"), Optional.empty());
    }

    public AccessPackageResourceRequest accessPackageResources(String id) {
        return new AccessPackageResourceRequest(contextPath.addSegment("accessPackageResources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageResourceCollectionRequest accessPackageResources() {
        return new AccessPackageResourceCollectionRequest(
                        contextPath.addSegment("accessPackageResources"), Optional.empty());
    }

    public AccessPackageResourceScopeRequest accessPackageResourceScopes(String id) {
        return new AccessPackageResourceScopeRequest(contextPath.addSegment("accessPackageResourceScopes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageResourceScopeCollectionRequest accessPackageResourceScopes() {
        return new AccessPackageResourceScopeCollectionRequest(
                        contextPath.addSegment("accessPackageResourceScopes"), Optional.empty());
    }

    public AccessPackageRequest accessPackages(String id) {
        return new AccessPackageRequest(contextPath.addSegment("accessPackages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageCollectionRequest accessPackages() {
        return new AccessPackageCollectionRequest(
                        contextPath.addSegment("accessPackages"), Optional.empty());
    }

    public CustomAccessPackageWorkflowExtensionRequest customAccessPackageWorkflowExtensions(String id) {
        return new CustomAccessPackageWorkflowExtensionRequest(contextPath.addSegment("customAccessPackageWorkflowExtensions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CustomAccessPackageWorkflowExtensionCollectionRequest customAccessPackageWorkflowExtensions() {
        return new CustomAccessPackageWorkflowExtensionCollectionRequest(
                        contextPath.addSegment("customAccessPackageWorkflowExtensions"), Optional.empty());
    }

}
