package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessPackageAssignmentResourceRole;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentCollectionRequest;

@JsonIgnoreType
public class AccessPackageAssignmentResourceRoleRequest extends EntityRequest<AccessPackageAssignmentResourceRole> {

    public AccessPackageAssignmentResourceRoleRequest(ContextPath contextPath, Optional<Object> value) {
        super(AccessPackageAssignmentResourceRole.class, contextPath, value, false);
    }

    public AccessPackageAssignmentRequest accessPackageAssignments(String id) {
        return new AccessPackageAssignmentRequest(contextPath.addSegment("accessPackageAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageAssignmentCollectionRequest accessPackageAssignments() {
        return new AccessPackageAssignmentCollectionRequest(
                        contextPath.addSegment("accessPackageAssignments"), Optional.empty());
    }

    public AccessPackageResourceRoleRequest accessPackageResourceRole() {
        return new AccessPackageResourceRoleRequest(contextPath.addSegment("accessPackageResourceRole"), Optional.empty());
    }

    public AccessPackageResourceScopeRequest accessPackageResourceScope() {
        return new AccessPackageResourceScopeRequest(contextPath.addSegment("accessPackageResourceScope"), Optional.empty());
    }

    public AccessPackageSubjectRequest accessPackageSubject() {
        return new AccessPackageSubjectRequest(contextPath.addSegment("accessPackageSubject"), Optional.empty());
    }

}
