package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessPackageAssignmentRequest;

@JsonIgnoreType
public class AccessPackageAssignmentRequestRequest extends EntityRequest<AccessPackageAssignmentRequest> {

    public AccessPackageAssignmentRequestRequest(ContextPath contextPath, Optional<Object> value) {
        super(AccessPackageAssignmentRequest.class, contextPath, value, false);
    }

    public AccessPackageRequest accessPackage() {
        return new AccessPackageRequest(contextPath.addSegment("accessPackage"), Optional.empty());
    }

    public odata.msgraph.client.beta.entity.request.AccessPackageAssignmentRequest accessPackageAssignment() {
        return new odata.msgraph.client.beta.entity.request.AccessPackageAssignmentRequest(contextPath.addSegment("accessPackageAssignment"), Optional.empty());
    }

    public AccessPackageSubjectRequest requestor() {
        return new AccessPackageSubjectRequest(contextPath.addSegment("requestor"), Optional.empty());
    }

    @Action(name = "cancel")
    @JsonIgnore
    public ActionRequestNoReturn cancel() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancel"), _parameters);
    }

    @Action(name = "reprocess")
    @JsonIgnore
    public ActionRequestNoReturn reprocess() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reprocess"), _parameters);
    }

}
