package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessPackageAssignment;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentResourceRoleCollectionRequest;

@JsonIgnoreType
public class AccessPackageAssignmentRequest extends EntityRequest<AccessPackageAssignment> {

    public AccessPackageAssignmentRequest(ContextPath contextPath, Optional<Object> value) {
        super(AccessPackageAssignment.class, contextPath, value, false);
    }

    public AccessPackageRequest accessPackage() {
        return new AccessPackageRequest(contextPath.addSegment("accessPackage"), Optional.empty());
    }

    public AccessPackageAssignmentPolicyRequest accessPackageAssignmentPolicy() {
        return new AccessPackageAssignmentPolicyRequest(contextPath.addSegment("accessPackageAssignmentPolicy"), Optional.empty());
    }

    public AccessPackageAssignmentRequestRequest accessPackageAssignmentRequests(String id) {
        return new AccessPackageAssignmentRequestRequest(contextPath.addSegment("accessPackageAssignmentRequests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageAssignmentRequestCollectionRequest accessPackageAssignmentRequests() {
        return new AccessPackageAssignmentRequestCollectionRequest(
                        contextPath.addSegment("accessPackageAssignmentRequests"), Optional.empty());
    }

    public AccessPackageAssignmentResourceRoleRequest accessPackageAssignmentResourceRoles(String id) {
        return new AccessPackageAssignmentResourceRoleRequest(contextPath.addSegment("accessPackageAssignmentResourceRoles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageAssignmentResourceRoleCollectionRequest accessPackageAssignmentResourceRoles() {
        return new AccessPackageAssignmentResourceRoleCollectionRequest(
                        contextPath.addSegment("accessPackageAssignmentResourceRoles"), Optional.empty());
    }

    public AccessPackageSubjectRequest target() {
        return new AccessPackageSubjectRequest(contextPath.addSegment("target"), Optional.empty());
    }

    @Action(name = "reprocess")
    @JsonIgnore
    public ActionRequestNoReturn reprocess() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reprocess"), _parameters);
    }

}
