package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessPackageAssignmentPolicy;
import odata.msgraph.client.beta.entity.collection.request.CustomExtensionHandlerCollectionRequest;

@JsonIgnoreType
public class AccessPackageAssignmentPolicyRequest extends EntityRequest<AccessPackageAssignmentPolicy> {

    public AccessPackageAssignmentPolicyRequest(ContextPath contextPath, Optional<Object> value) {
        super(AccessPackageAssignmentPolicy.class, contextPath, value, false);
    }

    public AccessPackageRequest accessPackage() {
        return new AccessPackageRequest(contextPath.addSegment("accessPackage"), Optional.empty());
    }

    public AccessPackageCatalogRequest accessPackageCatalog() {
        return new AccessPackageCatalogRequest(contextPath.addSegment("accessPackageCatalog"), Optional.empty());
    }

    public CustomExtensionHandlerRequest customExtensionHandlers(String id) {
        return new CustomExtensionHandlerRequest(contextPath.addSegment("customExtensionHandlers").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CustomExtensionHandlerCollectionRequest customExtensionHandlers() {
        return new CustomExtensionHandlerCollectionRequest(
                        contextPath.addSegment("customExtensionHandlers"), Optional.empty());
    }

}
