package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WorkbookTable;
import odata.msgraph.client.beta.entity.request.WorkbookTableColumnRequest;
import odata.msgraph.client.beta.entity.request.WorkbookTableRequest;
import odata.msgraph.client.beta.entity.request.WorkbookTableRowRequest;

public class WorkbookTableCollectionRequest extends CollectionPageEntityRequest<WorkbookTable, WorkbookTableRequest>{

    protected ContextPath contextPath;

    public WorkbookTableCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, WorkbookTable.class, cp -> new WorkbookTableRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public WorkbookTableColumnRequest columns(String id) {
        return new WorkbookTableColumnRequest(contextPath.addSegment("columns").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WorkbookTableColumnCollectionRequest columns() {
        return new WorkbookTableColumnCollectionRequest(contextPath.addSegment("columns"), Optional.empty());
    }

    public WorkbookTableRowRequest rows(String id) {
        return new WorkbookTableRowRequest(contextPath.addSegment("rows").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WorkbookTableRowCollectionRequest rows() {
        return new WorkbookTableRowCollectionRequest(contextPath.addSegment("rows"), Optional.empty());
    }

    @Action(name = "add")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookTable> add(String address, Boolean hasHeaders) {
        Preconditions.checkNotNull(hasHeaders, "hasHeaders cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("address", "Edm.String", Checks.checkIsAscii(address))
            .put("hasHeaders", "Edm.Boolean", hasHeaders)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookTable>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.add"), WorkbookTable.class, _parameters);
    }

    @Function(name = "count")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Integer> count() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<Integer>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.count"), Integer.class, _parameters);
    }

    @Function(name = "itemAt")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookTable> itemAt(Integer index) {
        Preconditions.checkNotNull(index, "index cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("index", "Edm.Int32", index)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookTable>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.itemAt"), WorkbookTable.class, _parameters);
    }

}
