package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WorkbookRangeView;
import odata.msgraph.client.beta.entity.request.WorkbookRangeViewRequest;

public class WorkbookRangeViewCollectionRequest extends CollectionPageEntityRequest<WorkbookRangeView, WorkbookRangeViewRequest>{

    protected ContextPath contextPath;

    public WorkbookRangeViewCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, WorkbookRangeView.class, cp -> new WorkbookRangeViewRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public WorkbookRangeViewRequest rows(String id) {
        return new WorkbookRangeViewRequest(contextPath.addSegment("rows").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WorkbookRangeViewCollectionRequest rows() {
        return new WorkbookRangeViewCollectionRequest(contextPath.addSegment("rows"), Optional.empty());
    }

    @Function(name = "itemAt")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRangeView> itemAt(Integer index) {
        Preconditions.checkNotNull(index, "index cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("index", "Edm.Int32", index)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRangeView>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.itemAt"), WorkbookRangeView.class, _parameters);
    }

}
