package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WorkbookChartPoint;
import odata.msgraph.client.beta.entity.request.WorkbookChartPointRequest;

public class WorkbookChartPointCollectionRequest extends CollectionPageEntityRequest<WorkbookChartPoint, WorkbookChartPointRequest>{

    protected ContextPath contextPath;

    public WorkbookChartPointCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, WorkbookChartPoint.class, cp -> new WorkbookChartPointRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Function(name = "count")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Integer> count() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<Integer>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.count"), Integer.class, _parameters);
    }

    @Function(name = "itemAt")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookChartPoint> itemAt(Integer index) {
        Preconditions.checkNotNull(index, "index cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("index", "Edm.Int32", index)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookChartPoint>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.itemAt"), WorkbookChartPoint.class, _parameters);
    }

}
