package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Json;
import odata.msgraph.client.beta.entity.WorkbookChart;
import odata.msgraph.client.beta.entity.request.WorkbookChartRequest;
import odata.msgraph.client.beta.entity.request.WorkbookChartSeriesRequest;

public class WorkbookChartCollectionRequest extends CollectionPageEntityRequest<WorkbookChart, WorkbookChartRequest>{

    protected ContextPath contextPath;

    public WorkbookChartCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, WorkbookChart.class, cp -> new WorkbookChartRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public WorkbookChartSeriesRequest series(String id) {
        return new WorkbookChartSeriesRequest(contextPath.addSegment("series").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WorkbookChartSeriesCollectionRequest series() {
        return new WorkbookChartSeriesCollectionRequest(contextPath.addSegment("series"), Optional.empty());
    }

    @Action(name = "add")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookChart> add(String type, Json sourceData, String seriesBy) {
        Preconditions.checkNotNull(type, "type cannot be null");
        Preconditions.checkNotNull(seriesBy, "seriesBy cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("type", "Edm.String", Checks.checkIsAscii(type))
            .put("sourceData", "microsoft.graph.Json", sourceData)
            .put("seriesBy", "Edm.String", Checks.checkIsAscii(seriesBy))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookChart>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.add"), WorkbookChart.class, _parameters);
    }

    @Function(name = "count")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Integer> count() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<Integer>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.count"), Integer.class, _parameters);
    }

    @Function(name = "item")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookChart> item(String name) {
        Preconditions.checkNotNull(name, "name cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookChart>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.item"), WorkbookChart.class, _parameters);
    }

    @Function(name = "itemAt")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookChart> itemAt(Integer index) {
        Preconditions.checkNotNull(index, "index cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("index", "Edm.Int32", index)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookChart>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.itemAt"), WorkbookChart.class, _parameters);
    }

}
