package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WindowsFeatureUpdateProfile;
import odata.msgraph.client.beta.entity.request.WindowsFeatureUpdateProfileAssignmentRequest;
import odata.msgraph.client.beta.entity.request.WindowsFeatureUpdateProfileRequest;

public class WindowsFeatureUpdateProfileCollectionRequest extends CollectionPageEntityRequest<WindowsFeatureUpdateProfile, WindowsFeatureUpdateProfileRequest>{

    protected ContextPath contextPath;

    public WindowsFeatureUpdateProfileCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, WindowsFeatureUpdateProfile.class, cp -> new WindowsFeatureUpdateProfileRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public WindowsFeatureUpdateProfileAssignmentRequest assignments(String id) {
        return new WindowsFeatureUpdateProfileAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsFeatureUpdateProfileAssignmentCollectionRequest assignments() {
        return new WindowsFeatureUpdateProfileAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

}
