package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UserExperienceAnalyticsWorkFromAnywhereMetric;
import odata.msgraph.client.beta.entity.request.UserExperienceAnalyticsWorkFromAnywhereDeviceRequest;
import odata.msgraph.client.beta.entity.request.UserExperienceAnalyticsWorkFromAnywhereMetricRequest;

public class UserExperienceAnalyticsWorkFromAnywhereMetricCollectionRequest extends CollectionPageEntityRequest<UserExperienceAnalyticsWorkFromAnywhereMetric, UserExperienceAnalyticsWorkFromAnywhereMetricRequest>{

    protected ContextPath contextPath;

    public UserExperienceAnalyticsWorkFromAnywhereMetricCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, UserExperienceAnalyticsWorkFromAnywhereMetric.class, cp -> new UserExperienceAnalyticsWorkFromAnywhereMetricRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public UserExperienceAnalyticsWorkFromAnywhereDeviceRequest metricDevices(String id) {
        return new UserExperienceAnalyticsWorkFromAnywhereDeviceRequest(contextPath.addSegment("metricDevices").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsWorkFromAnywhereDeviceCollectionRequest metricDevices() {
        return new UserExperienceAnalyticsWorkFromAnywhereDeviceCollectionRequest(contextPath.addSegment("metricDevices"), Optional.empty());
    }

}
