package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.PasswordValidationInformation;
import odata.msgraph.client.beta.entity.User;
import odata.msgraph.client.beta.entity.request.AccessReviewInstanceRequest;
import odata.msgraph.client.beta.entity.request.AgreementAcceptanceRequest;
import odata.msgraph.client.beta.entity.request.AppConsentRequestRequest;
import odata.msgraph.client.beta.entity.request.AppRoleAssignmentRequest;
import odata.msgraph.client.beta.entity.request.ApprovalRequest;
import odata.msgraph.client.beta.entity.request.CalendarGroupRequest;
import odata.msgraph.client.beta.entity.request.CalendarRequest;
import odata.msgraph.client.beta.entity.request.ChatRequest;
import odata.msgraph.client.beta.entity.request.ContactFolderRequest;
import odata.msgraph.client.beta.entity.request.ContactRequest;
import odata.msgraph.client.beta.entity.request.DeviceEnrollmentConfigurationRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementTroubleshootingEventRequest;
import odata.msgraph.client.beta.entity.request.DeviceRequest;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.DriveRequest;
import odata.msgraph.client.beta.entity.request.EventRequest;
import odata.msgraph.client.beta.entity.request.ExtensionRequest;
import odata.msgraph.client.beta.entity.request.GroupRequest;
import odata.msgraph.client.beta.entity.request.LicenseDetailsRequest;
import odata.msgraph.client.beta.entity.request.MailFolderRequest;
import odata.msgraph.client.beta.entity.request.ManagedAppRegistrationRequest;
import odata.msgraph.client.beta.entity.request.ManagedDeviceRequest;
import odata.msgraph.client.beta.entity.request.MessageRequest;
import odata.msgraph.client.beta.entity.request.MobileAppIntentAndStateRequest;
import odata.msgraph.client.beta.entity.request.MobileAppTroubleshootingEventRequest;
import odata.msgraph.client.beta.entity.request.NotificationRequest;
import odata.msgraph.client.beta.entity.request.OAuth2PermissionGrantRequest;
import odata.msgraph.client.beta.entity.request.OnlineMeetingRequest;
import odata.msgraph.client.beta.entity.request.PersonRequest;
import odata.msgraph.client.beta.entity.request.ProfilePhotoRequest;
import odata.msgraph.client.beta.entity.request.ScopedRoleMembershipRequest;
import odata.msgraph.client.beta.entity.request.SiteRequest;
import odata.msgraph.client.beta.entity.request.TeamRequest;
import odata.msgraph.client.beta.entity.request.UsageRightRequest;
import odata.msgraph.client.beta.entity.request.UserActivityRequest;
import odata.msgraph.client.beta.entity.request.UserRequest;
import odata.msgraph.client.beta.entity.request.WindowsInformationProtectionDeviceRegistrationRequest;

public class UserCollectionRequest extends CollectionPageEntityRequest<User, UserRequest>{

    protected ContextPath contextPath;

    public UserCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, User.class, cp -> new UserRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public UsageRightRequest usageRights(String id) {
        return new UsageRightRequest(contextPath.addSegment("usageRights").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UsageRightCollectionRequest usageRights() {
        return new UsageRightCollectionRequest(contextPath.addSegment("usageRights"), Optional.empty());
    }

    public AppRoleAssignmentRequest appRoleAssignments(String id) {
        return new AppRoleAssignmentRequest(contextPath.addSegment("appRoleAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AppRoleAssignmentCollectionRequest appRoleAssignments() {
        return new AppRoleAssignmentCollectionRequest(contextPath.addSegment("appRoleAssignments"), Optional.empty());
    }

    public DirectoryObjectRequest createdObjects(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("createdObjects").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest createdObjects() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("createdObjects"), Optional.empty());
    }

    public DirectoryObjectRequest directReports(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("directReports").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest directReports() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("directReports"), Optional.empty());
    }

    public LicenseDetailsRequest licenseDetails(String id) {
        return new LicenseDetailsRequest(contextPath.addSegment("licenseDetails").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public LicenseDetailsCollectionRequest licenseDetails() {
        return new LicenseDetailsCollectionRequest(contextPath.addSegment("licenseDetails"), Optional.empty());
    }

    public DirectoryObjectRequest memberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("memberOf").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest memberOf() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("memberOf"), Optional.empty());
    }

    public OAuth2PermissionGrantRequest oauth2PermissionGrants(String id) {
        return new OAuth2PermissionGrantRequest(contextPath.addSegment("oauth2PermissionGrants").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OAuth2PermissionGrantCollectionRequest oauth2PermissionGrants() {
        return new OAuth2PermissionGrantCollectionRequest(contextPath.addSegment("oauth2PermissionGrants"), Optional.empty());
    }

    public DirectoryObjectRequest ownedDevices(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("ownedDevices").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest ownedDevices() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("ownedDevices"), Optional.empty());
    }

    public DirectoryObjectRequest ownedObjects(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("ownedObjects").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest ownedObjects() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("ownedObjects"), Optional.empty());
    }

    public DirectoryObjectRequest registeredDevices(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("registeredDevices").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest registeredDevices() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("registeredDevices"), Optional.empty());
    }

    public ScopedRoleMembershipRequest scopedRoleMemberOf(String id) {
        return new ScopedRoleMembershipRequest(contextPath.addSegment("scopedRoleMemberOf").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ScopedRoleMembershipCollectionRequest scopedRoleMemberOf() {
        return new ScopedRoleMembershipCollectionRequest(contextPath.addSegment("scopedRoleMemberOf"), Optional.empty());
    }

    public DirectoryObjectRequest transitiveMemberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("transitiveMemberOf").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest transitiveMemberOf() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("transitiveMemberOf"), Optional.empty());
    }

    public DirectoryObjectRequest transitiveReports(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("transitiveReports").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest transitiveReports() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("transitiveReports"), Optional.empty());
    }

    public CalendarGroupRequest calendarGroups(String id) {
        return new CalendarGroupRequest(contextPath.addSegment("calendarGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CalendarGroupCollectionRequest calendarGroups() {
        return new CalendarGroupCollectionRequest(contextPath.addSegment("calendarGroups"), Optional.empty());
    }

    public CalendarRequest calendars(String id) {
        return new CalendarRequest(contextPath.addSegment("calendars").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CalendarCollectionRequest calendars() {
        return new CalendarCollectionRequest(contextPath.addSegment("calendars"), Optional.empty());
    }

    public EventRequest calendarView(String id) {
        return new EventRequest(contextPath.addSegment("calendarView").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EventCollectionRequest calendarView() {
        return new EventCollectionRequest(contextPath.addSegment("calendarView"), Optional.empty());
    }

    public ContactFolderRequest contactFolders(String id) {
        return new ContactFolderRequest(contextPath.addSegment("contactFolders").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ContactFolderCollectionRequest contactFolders() {
        return new ContactFolderCollectionRequest(contextPath.addSegment("contactFolders"), Optional.empty());
    }

    public ContactRequest contacts(String id) {
        return new ContactRequest(contextPath.addSegment("contacts").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ContactCollectionRequest contacts() {
        return new ContactCollectionRequest(contextPath.addSegment("contacts"), Optional.empty());
    }

    public EventRequest events(String id) {
        return new EventRequest(contextPath.addSegment("events").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EventCollectionRequest events() {
        return new EventCollectionRequest(contextPath.addSegment("events"), Optional.empty());
    }

    public GroupRequest joinedGroups(String id) {
        return new GroupRequest(contextPath.addSegment("joinedGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupCollectionRequest joinedGroups() {
        return new GroupCollectionRequest(contextPath.addSegment("joinedGroups"), Optional.empty());
    }

    public MailFolderRequest mailFolders(String id) {
        return new MailFolderRequest(contextPath.addSegment("mailFolders").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MailFolderCollectionRequest mailFolders() {
        return new MailFolderCollectionRequest(contextPath.addSegment("mailFolders"), Optional.empty());
    }

    public MessageRequest messages(String id) {
        return new MessageRequest(contextPath.addSegment("messages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MessageCollectionRequest messages() {
        return new MessageCollectionRequest(contextPath.addSegment("messages"), Optional.empty());
    }

    public PersonRequest people(String id) {
        return new PersonRequest(contextPath.addSegment("people").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PersonCollectionRequest people() {
        return new PersonCollectionRequest(contextPath.addSegment("people"), Optional.empty());
    }

    public DriveRequest drives(String id) {
        return new DriveRequest(contextPath.addSegment("drives").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DriveCollectionRequest drives() {
        return new DriveCollectionRequest(contextPath.addSegment("drives"), Optional.empty());
    }

    public SiteRequest followedSites(String id) {
        return new SiteRequest(contextPath.addSegment("followedSites").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SiteCollectionRequest followedSites() {
        return new SiteCollectionRequest(contextPath.addSegment("followedSites"), Optional.empty());
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(contextPath.addSegment("extensions"), Optional.empty());
    }

    public AppConsentRequestRequest appConsentRequestsForApproval(String id) {
        return new AppConsentRequestRequest(contextPath.addSegment("appConsentRequestsForApproval").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AppConsentRequestCollectionRequest appConsentRequestsForApproval() {
        return new AppConsentRequestCollectionRequest(contextPath.addSegment("appConsentRequestsForApproval"), Optional.empty());
    }

    public ApprovalRequest approvals(String id) {
        return new ApprovalRequest(contextPath.addSegment("approvals").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ApprovalCollectionRequest approvals() {
        return new ApprovalCollectionRequest(contextPath.addSegment("approvals"), Optional.empty());
    }

    public AccessReviewInstanceRequest pendingAccessReviewInstances(String id) {
        return new AccessReviewInstanceRequest(contextPath.addSegment("pendingAccessReviewInstances").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviewInstanceCollectionRequest pendingAccessReviewInstances() {
        return new AccessReviewInstanceCollectionRequest(contextPath.addSegment("pendingAccessReviewInstances"), Optional.empty());
    }

    public AgreementAcceptanceRequest agreementAcceptances(String id) {
        return new AgreementAcceptanceRequest(contextPath.addSegment("agreementAcceptances").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AgreementAcceptanceCollectionRequest agreementAcceptances() {
        return new AgreementAcceptanceCollectionRequest(contextPath.addSegment("agreementAcceptances"), Optional.empty());
    }

    public DeviceEnrollmentConfigurationRequest deviceEnrollmentConfigurations(String id) {
        return new DeviceEnrollmentConfigurationRequest(contextPath.addSegment("deviceEnrollmentConfigurations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceEnrollmentConfigurationCollectionRequest deviceEnrollmentConfigurations() {
        return new DeviceEnrollmentConfigurationCollectionRequest(contextPath.addSegment("deviceEnrollmentConfigurations"), Optional.empty());
    }

    public ManagedDeviceRequest managedDevices(String id) {
        return new ManagedDeviceRequest(contextPath.addSegment("managedDevices").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedDeviceCollectionRequest managedDevices() {
        return new ManagedDeviceCollectionRequest(contextPath.addSegment("managedDevices"), Optional.empty());
    }

    public ManagedAppRegistrationRequest managedAppRegistrations(String id) {
        return new ManagedAppRegistrationRequest(contextPath.addSegment("managedAppRegistrations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedAppRegistrationCollectionRequest managedAppRegistrations() {
        return new ManagedAppRegistrationCollectionRequest(contextPath.addSegment("managedAppRegistrations"), Optional.empty());
    }

    public WindowsInformationProtectionDeviceRegistrationRequest windowsInformationProtectionDeviceRegistrations(String id) {
        return new WindowsInformationProtectionDeviceRegistrationRequest(contextPath.addSegment("windowsInformationProtectionDeviceRegistrations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsInformationProtectionDeviceRegistrationCollectionRequest windowsInformationProtectionDeviceRegistrations() {
        return new WindowsInformationProtectionDeviceRegistrationCollectionRequest(contextPath.addSegment("windowsInformationProtectionDeviceRegistrations"), Optional.empty());
    }

    public DeviceManagementTroubleshootingEventRequest deviceManagementTroubleshootingEvents(String id) {
        return new DeviceManagementTroubleshootingEventRequest(contextPath.addSegment("deviceManagementTroubleshootingEvents").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementTroubleshootingEventCollectionRequest deviceManagementTroubleshootingEvents() {
        return new DeviceManagementTroubleshootingEventCollectionRequest(contextPath.addSegment("deviceManagementTroubleshootingEvents"), Optional.empty());
    }

    public MobileAppIntentAndStateRequest mobileAppIntentAndStates(String id) {
        return new MobileAppIntentAndStateRequest(contextPath.addSegment("mobileAppIntentAndStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobileAppIntentAndStateCollectionRequest mobileAppIntentAndStates() {
        return new MobileAppIntentAndStateCollectionRequest(contextPath.addSegment("mobileAppIntentAndStates"), Optional.empty());
    }

    public MobileAppTroubleshootingEventRequest mobileAppTroubleshootingEvents(String id) {
        return new MobileAppTroubleshootingEventRequest(contextPath.addSegment("mobileAppTroubleshootingEvents").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobileAppTroubleshootingEventCollectionRequest mobileAppTroubleshootingEvents() {
        return new MobileAppTroubleshootingEventCollectionRequest(contextPath.addSegment("mobileAppTroubleshootingEvents"), Optional.empty());
    }

    public NotificationRequest notifications(String id) {
        return new NotificationRequest(contextPath.addSegment("notifications").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public NotificationCollectionRequest notifications() {
        return new NotificationCollectionRequest(contextPath.addSegment("notifications"), Optional.empty());
    }

    public ProfilePhotoRequest photos(String id) {
        return new ProfilePhotoRequest(contextPath.addSegment("photos").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ProfilePhotoCollectionRequest photos() {
        return new ProfilePhotoCollectionRequest(contextPath.addSegment("photos"), Optional.empty());
    }

    public UserActivityRequest activities(String id) {
        return new UserActivityRequest(contextPath.addSegment("activities").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserActivityCollectionRequest activities() {
        return new UserActivityCollectionRequest(contextPath.addSegment("activities"), Optional.empty());
    }

    public DeviceRequest devices(String id) {
        return new DeviceRequest(contextPath.addSegment("devices").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceCollectionRequest devices() {
        return new DeviceCollectionRequest(contextPath.addSegment("devices"), Optional.empty());
    }

    public OnlineMeetingRequest onlineMeetings(String id) {
        return new OnlineMeetingRequest(contextPath.addSegment("onlineMeetings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OnlineMeetingCollectionRequest onlineMeetings() {
        return new OnlineMeetingCollectionRequest(contextPath.addSegment("onlineMeetings"), Optional.empty());
    }

    public ChatRequest chats(String id) {
        return new ChatRequest(contextPath.addSegment("chats").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ChatCollectionRequest chats() {
        return new ChatCollectionRequest(contextPath.addSegment("chats"), Optional.empty());
    }

    public TeamRequest joinedTeams(String id) {
        return new TeamRequest(contextPath.addSegment("joinedTeams").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TeamCollectionRequest joinedTeams() {
        return new TeamCollectionRequest(contextPath.addSegment("joinedTeams"), Optional.empty());
    }

    @Action(name = "validatePassword")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PasswordValidationInformation> validatePassword(String password) {
        Preconditions.checkNotNull(password, "password cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("password", "Edm.String", Checks.checkIsAscii(password))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PasswordValidationInformation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.validatePassword"), PasswordValidationInformation.class, _parameters);
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<User> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), User.class, _parameters);
    }

    @Function(name = "getManagedAppBlockedUsers")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> getManagedAppBlockedUsers() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getManagedAppBlockedUsers"), String.class, _parameters);
    }

}
