package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UnifiedRoleManagementPolicy;
import odata.msgraph.client.beta.entity.request.UnifiedRoleManagementPolicyRequest;
import odata.msgraph.client.beta.entity.request.UnifiedRoleManagementPolicyRuleRequest;

public class UnifiedRoleManagementPolicyCollectionRequest extends CollectionPageEntityRequest<UnifiedRoleManagementPolicy, UnifiedRoleManagementPolicyRequest>{

    protected ContextPath contextPath;

    public UnifiedRoleManagementPolicyCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, UnifiedRoleManagementPolicy.class, cp -> new UnifiedRoleManagementPolicyRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public UnifiedRoleManagementPolicyRuleRequest effectiveRules(String id) {
        return new UnifiedRoleManagementPolicyRuleRequest(contextPath.addSegment("effectiveRules").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedRoleManagementPolicyRuleCollectionRequest effectiveRules() {
        return new UnifiedRoleManagementPolicyRuleCollectionRequest(contextPath.addSegment("effectiveRules"), Optional.empty());
    }

    public UnifiedRoleManagementPolicyRuleRequest rules(String id) {
        return new UnifiedRoleManagementPolicyRuleRequest(contextPath.addSegment("rules").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedRoleManagementPolicyRuleCollectionRequest rules() {
        return new UnifiedRoleManagementPolicyRuleCollectionRequest(contextPath.addSegment("rules"), Optional.empty());
    }

}
