package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UnifiedRoleDefinition;
import odata.msgraph.client.beta.entity.request.UnifiedRoleDefinitionRequest;

public class UnifiedRoleDefinitionCollectionRequest extends CollectionPageEntityRequest<UnifiedRoleDefinition, UnifiedRoleDefinitionRequest>{

    protected ContextPath contextPath;

    public UnifiedRoleDefinitionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, UnifiedRoleDefinition.class, cp -> new UnifiedRoleDefinitionRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public UnifiedRoleDefinitionRequest inheritsPermissionsFrom(String id) {
        return new UnifiedRoleDefinitionRequest(contextPath.addSegment("inheritsPermissionsFrom").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedRoleDefinitionCollectionRequest inheritsPermissionsFrom() {
        return new UnifiedRoleDefinitionCollectionRequest(contextPath.addSegment("inheritsPermissionsFrom"), Optional.empty());
    }

}
