package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UnifiedRoleAssignmentScheduleRequest;
import odata.msgraph.client.beta.entity.request.UnifiedRoleAssignmentScheduleRequestRequest;
import odata.msgraph.client.beta.enums.RoleAssignmentScheduleRequestFilterByCurrentUserOptions;

public class UnifiedRoleAssignmentScheduleRequestCollectionRequest extends CollectionPageEntityRequest<UnifiedRoleAssignmentScheduleRequest, UnifiedRoleAssignmentScheduleRequestRequest>{

    protected ContextPath contextPath;

    public UnifiedRoleAssignmentScheduleRequestCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, UnifiedRoleAssignmentScheduleRequest.class, cp -> new UnifiedRoleAssignmentScheduleRequestRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Function(name = "filterByCurrentUser")
    @JsonIgnore
    public CollectionPageNonEntityRequest<UnifiedRoleAssignmentScheduleRequest> filterByCurrentUser(RoleAssignmentScheduleRequestFilterByCurrentUserOptions on) {
        Preconditions.checkNotNull(on, "on cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("on", "microsoft.graph.roleAssignmentScheduleRequestFilterByCurrentUserOptions", on)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.filterByCurrentUser"), UnifiedRoleAssignmentScheduleRequest.class, _parameters);
    }

}
