package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UnifiedRoleAssignmentScheduleInstance;
import odata.msgraph.client.beta.entity.request.UnifiedRoleAssignmentScheduleInstanceRequest;
import odata.msgraph.client.beta.enums.RoleAssignmentScheduleInstanceFilterByCurrentUserOptions;

public class UnifiedRoleAssignmentScheduleInstanceCollectionRequest extends CollectionPageEntityRequest<UnifiedRoleAssignmentScheduleInstance, UnifiedRoleAssignmentScheduleInstanceRequest>{

    protected ContextPath contextPath;

    public UnifiedRoleAssignmentScheduleInstanceCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, UnifiedRoleAssignmentScheduleInstance.class, cp -> new UnifiedRoleAssignmentScheduleInstanceRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Function(name = "filterByCurrentUser")
    @JsonIgnore
    public CollectionPageNonEntityRequest<UnifiedRoleAssignmentScheduleInstance> filterByCurrentUser(RoleAssignmentScheduleInstanceFilterByCurrentUserOptions on) {
        Preconditions.checkNotNull(on, "on cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("on", "microsoft.graph.roleAssignmentScheduleInstanceFilterByCurrentUserOptions", on)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.filterByCurrentUser"), UnifiedRoleAssignmentScheduleInstance.class, _parameters);
    }

}
