package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UnifiedRoleAssignmentMultiple;
import odata.msgraph.client.beta.entity.request.AppScopeRequest;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.UnifiedRoleAssignmentMultipleRequest;

public class UnifiedRoleAssignmentMultipleCollectionRequest extends CollectionPageEntityRequest<UnifiedRoleAssignmentMultiple, UnifiedRoleAssignmentMultipleRequest>{

    protected ContextPath contextPath;

    public UnifiedRoleAssignmentMultipleCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, UnifiedRoleAssignmentMultiple.class, cp -> new UnifiedRoleAssignmentMultipleRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AppScopeRequest appScopes(String id) {
        return new AppScopeRequest(contextPath.addSegment("appScopes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AppScopeCollectionRequest appScopes() {
        return new AppScopeCollectionRequest(contextPath.addSegment("appScopes"), Optional.empty());
    }

    public DirectoryObjectRequest directoryScopes(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("directoryScopes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest directoryScopes() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("directoryScopes"), Optional.empty());
    }

    public DirectoryObjectRequest principals(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("principals").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest principals() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("principals"), Optional.empty());
    }

}
