package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ItemBody;
import odata.msgraph.client.beta.entity.TimeCard;
import odata.msgraph.client.beta.entity.request.TimeCardRequest;

public class TimeCardCollectionRequest extends CollectionPageEntityRequest<TimeCard, TimeCardRequest>{

    protected ContextPath contextPath;

    public TimeCardCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, TimeCard.class, cp -> new TimeCardRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Action(name = "clockIn")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<TimeCard> clockIn(Boolean atApprovedLocation, String onBehalfOfUserId, ItemBody notes) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("atApprovedLocation", "Edm.Boolean", atApprovedLocation)
            .put("onBehalfOfUserId", "Edm.String", Checks.checkIsAscii(onBehalfOfUserId))
            .put("notes", "microsoft.graph.itemBody", notes)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<TimeCard>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.clockIn"), TimeCard.class, _parameters);
    }

}
