package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ResultInfo;
import odata.msgraph.client.beta.entity.TiIndicator;
import odata.msgraph.client.beta.entity.request.TiIndicatorRequest;

public class TiIndicatorCollectionRequest extends CollectionPageEntityRequest<TiIndicator, TiIndicatorRequest>{

    protected ContextPath contextPath;

    public TiIndicatorCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, TiIndicator.class, cp -> new TiIndicatorRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Action(name = "deleteTiIndicators")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ResultInfo> deleteTiIndicators(List<String> value) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("value", "Collection(Edm.String)", Checks.checkIsAscii(value))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.deleteTiIndicators"), ResultInfo.class, _parameters);
    }

    @Action(name = "deleteTiIndicatorsByExternalId")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ResultInfo> deleteTiIndicatorsByExternalId(List<String> value) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("value", "Collection(Edm.String)", Checks.checkIsAscii(value))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.deleteTiIndicatorsByExternalId"), ResultInfo.class, _parameters);
    }

    @Action(name = "submitTiIndicators")
    @JsonIgnore
    public CollectionPageNonEntityRequest<TiIndicator> submitTiIndicators(List<TiIndicator> value) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("value", "Collection(microsoft.graph.tiIndicator)", value)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.submitTiIndicators"), TiIndicator.class, _parameters);
    }

    @Action(name = "updateTiIndicators")
    @JsonIgnore
    public CollectionPageNonEntityRequest<TiIndicator> updateTiIndicators(List<TiIndicator> value) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("value", "Collection(microsoft.graph.tiIndicator)", value)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateTiIndicators"), TiIndicator.class, _parameters);
    }

}
