package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.TeamworkTag;
import odata.msgraph.client.beta.entity.request.TeamworkTagMemberRequest;
import odata.msgraph.client.beta.entity.request.TeamworkTagRequest;

public class TeamworkTagCollectionRequest extends CollectionPageEntityRequest<TeamworkTag, TeamworkTagRequest>{

    protected ContextPath contextPath;

    public TeamworkTagCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, TeamworkTag.class, cp -> new TeamworkTagRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public TeamworkTagMemberRequest members(String id) {
        return new TeamworkTagMemberRequest(contextPath.addSegment("members").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TeamworkTagMemberCollectionRequest members() {
        return new TeamworkTagMemberCollectionRequest(contextPath.addSegment("members"), Optional.empty());
    }

}
