package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.TeamworkDevice;
import odata.msgraph.client.beta.entity.request.TeamworkDeviceOperationRequest;
import odata.msgraph.client.beta.entity.request.TeamworkDeviceRequest;

public class TeamworkDeviceCollectionRequest extends CollectionPageEntityRequest<TeamworkDevice, TeamworkDeviceRequest>{

    protected ContextPath contextPath;

    public TeamworkDeviceCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, TeamworkDevice.class, cp -> new TeamworkDeviceRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public TeamworkDeviceOperationRequest operations(String id) {
        return new TeamworkDeviceOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TeamworkDeviceOperationCollectionRequest operations() {
        return new TeamworkDeviceOperationCollectionRequest(contextPath.addSegment("operations"), Optional.empty());
    }

}
