package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.TeamsApp;
import odata.msgraph.client.beta.entity.request.TeamsAppDefinitionRequest;
import odata.msgraph.client.beta.entity.request.TeamsAppRequest;

public class TeamsAppCollectionRequest extends CollectionPageEntityRequest<TeamsApp, TeamsAppRequest>{

    protected ContextPath contextPath;

    public TeamsAppCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, TeamsApp.class, cp -> new TeamsAppRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public TeamsAppDefinitionRequest appDefinitions(String id) {
        return new TeamsAppDefinitionRequest(contextPath.addSegment("appDefinitions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TeamsAppDefinitionCollectionRequest appDefinitions() {
        return new TeamsAppDefinitionCollectionRequest(contextPath.addSegment("appDefinitions"), Optional.empty());
    }

}
