package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ChatMessage;
import odata.msgraph.client.beta.entity.Team;
import odata.msgraph.client.beta.entity.request.ChannelRequest;
import odata.msgraph.client.beta.entity.request.ConversationMemberRequest;
import odata.msgraph.client.beta.entity.request.ResourceSpecificPermissionGrantRequest;
import odata.msgraph.client.beta.entity.request.TeamRequest;
import odata.msgraph.client.beta.entity.request.TeamsAppInstallationRequest;
import odata.msgraph.client.beta.entity.request.TeamsAsyncOperationRequest;
import odata.msgraph.client.beta.entity.request.TeamworkTagRequest;
import odata.msgraph.client.beta.entity.request.UserRequest;

public class TeamCollectionRequest extends CollectionPageEntityRequest<Team, TeamRequest>{

    protected ContextPath contextPath;

    public TeamCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Team.class, cp -> new TeamRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ChannelRequest channels(String id) {
        return new ChannelRequest(contextPath.addSegment("channels").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ChannelCollectionRequest channels() {
        return new ChannelCollectionRequest(contextPath.addSegment("channels"), Optional.empty());
    }

    public TeamsAppInstallationRequest installedApps(String id) {
        return new TeamsAppInstallationRequest(contextPath.addSegment("installedApps").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TeamsAppInstallationCollectionRequest installedApps() {
        return new TeamsAppInstallationCollectionRequest(contextPath.addSegment("installedApps"), Optional.empty());
    }

    public ConversationMemberRequest members(String id) {
        return new ConversationMemberRequest(contextPath.addSegment("members").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConversationMemberCollectionRequest members() {
        return new ConversationMemberCollectionRequest(contextPath.addSegment("members"), Optional.empty());
    }

    public TeamsAsyncOperationRequest operations(String id) {
        return new TeamsAsyncOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TeamsAsyncOperationCollectionRequest operations() {
        return new TeamsAsyncOperationCollectionRequest(contextPath.addSegment("operations"), Optional.empty());
    }

    public UserRequest owners(String id) {
        return new UserRequest(contextPath.addSegment("owners").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserCollectionRequest owners() {
        return new UserCollectionRequest(contextPath.addSegment("owners"), Optional.empty());
    }

    public ResourceSpecificPermissionGrantRequest permissionGrants(String id) {
        return new ResourceSpecificPermissionGrantRequest(contextPath.addSegment("permissionGrants").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ResourceSpecificPermissionGrantCollectionRequest permissionGrants() {
        return new ResourceSpecificPermissionGrantCollectionRequest(contextPath.addSegment("permissionGrants"), Optional.empty());
    }

    public TeamworkTagRequest tags(String id) {
        return new TeamworkTagRequest(contextPath.addSegment("tags").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TeamworkTagCollectionRequest tags() {
        return new TeamworkTagCollectionRequest(contextPath.addSegment("tags"), Optional.empty());
    }

    @Function(name = "allMessages")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ChatMessage> allMessages() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.allMessages"), ChatMessage.class, _parameters);
    }

    @Function(name = "getAllMessages")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ChatMessage> getAllMessages() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAllMessages"), ChatMessage.class, _parameters);
    }

}
