package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.SimulationAutomation;
import odata.msgraph.client.beta.entity.request.SimulationAutomationRequest;
import odata.msgraph.client.beta.entity.request.SimulationAutomationRunRequest;

public class SimulationAutomationCollectionRequest extends CollectionPageEntityRequest<SimulationAutomation, SimulationAutomationRequest>{

    protected ContextPath contextPath;

    public SimulationAutomationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, SimulationAutomation.class, cp -> new SimulationAutomationRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SimulationAutomationRunRequest runs(String id) {
        return new SimulationAutomationRunRequest(contextPath.addSegment("runs").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SimulationAutomationRunCollectionRequest runs() {
        return new SimulationAutomationRunCollectionRequest(contextPath.addSegment("runs"), Optional.empty());
    }

}
