package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.SharedDriveItem;
import odata.msgraph.client.beta.entity.request.DriveItemRequest;
import odata.msgraph.client.beta.entity.request.SharedDriveItemRequest;

public class SharedDriveItemCollectionRequest extends CollectionPageEntityRequest<SharedDriveItem, SharedDriveItemRequest>{

    protected ContextPath contextPath;

    public SharedDriveItemCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, SharedDriveItem.class, cp -> new SharedDriveItemRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DriveItemRequest items(String id) {
        return new DriveItemRequest(contextPath.addSegment("items").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DriveItemCollectionRequest items() {
        return new DriveItemCollectionRequest(contextPath.addSegment("items"), Optional.empty());
    }

}
