package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ServicePrincipal;
import odata.msgraph.client.beta.entity.request.AppManagementPolicyRequest;
import odata.msgraph.client.beta.entity.request.AppRoleAssignmentRequest;
import odata.msgraph.client.beta.entity.request.ClaimsMappingPolicyRequest;
import odata.msgraph.client.beta.entity.request.DelegatedPermissionClassificationRequest;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.EndpointRequest;
import odata.msgraph.client.beta.entity.request.FederatedIdentityCredentialRequest;
import odata.msgraph.client.beta.entity.request.HomeRealmDiscoveryPolicyRequest;
import odata.msgraph.client.beta.entity.request.LicenseDetailsRequest;
import odata.msgraph.client.beta.entity.request.OAuth2PermissionGrantRequest;
import odata.msgraph.client.beta.entity.request.ServicePrincipalRequest;
import odata.msgraph.client.beta.entity.request.TokenIssuancePolicyRequest;
import odata.msgraph.client.beta.entity.request.TokenLifetimePolicyRequest;

public class ServicePrincipalCollectionRequest extends CollectionPageEntityRequest<ServicePrincipal, ServicePrincipalRequest>{

    protected ContextPath contextPath;

    public ServicePrincipalCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ServicePrincipal.class, cp -> new ServicePrincipalRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AppManagementPolicyRequest appManagementPolicies(String id) {
        return new AppManagementPolicyRequest(contextPath.addSegment("appManagementPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AppManagementPolicyCollectionRequest appManagementPolicies() {
        return new AppManagementPolicyCollectionRequest(contextPath.addSegment("appManagementPolicies"), Optional.empty());
    }

    public AppRoleAssignmentRequest appRoleAssignedTo(String id) {
        return new AppRoleAssignmentRequest(contextPath.addSegment("appRoleAssignedTo").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AppRoleAssignmentCollectionRequest appRoleAssignedTo() {
        return new AppRoleAssignmentCollectionRequest(contextPath.addSegment("appRoleAssignedTo"), Optional.empty());
    }

    public AppRoleAssignmentRequest appRoleAssignments(String id) {
        return new AppRoleAssignmentRequest(contextPath.addSegment("appRoleAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AppRoleAssignmentCollectionRequest appRoleAssignments() {
        return new AppRoleAssignmentCollectionRequest(contextPath.addSegment("appRoleAssignments"), Optional.empty());
    }

    public ClaimsMappingPolicyRequest claimsMappingPolicies(String id) {
        return new ClaimsMappingPolicyRequest(contextPath.addSegment("claimsMappingPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ClaimsMappingPolicyCollectionRequest claimsMappingPolicies() {
        return new ClaimsMappingPolicyCollectionRequest(contextPath.addSegment("claimsMappingPolicies"), Optional.empty());
    }

    public DirectoryObjectRequest createdObjects(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("createdObjects").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest createdObjects() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("createdObjects"), Optional.empty());
    }

    public DelegatedPermissionClassificationRequest delegatedPermissionClassifications(String id) {
        return new DelegatedPermissionClassificationRequest(contextPath.addSegment("delegatedPermissionClassifications").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DelegatedPermissionClassificationCollectionRequest delegatedPermissionClassifications() {
        return new DelegatedPermissionClassificationCollectionRequest(contextPath.addSegment("delegatedPermissionClassifications"), Optional.empty());
    }

    public EndpointRequest endpoints(String id) {
        return new EndpointRequest(contextPath.addSegment("endpoints").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EndpointCollectionRequest endpoints() {
        return new EndpointCollectionRequest(contextPath.addSegment("endpoints"), Optional.empty());
    }

    public FederatedIdentityCredentialRequest federatedIdentityCredentials(String id) {
        return new FederatedIdentityCredentialRequest(contextPath.addSegment("federatedIdentityCredentials").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public FederatedIdentityCredentialCollectionRequest federatedIdentityCredentials() {
        return new FederatedIdentityCredentialCollectionRequest(contextPath.addSegment("federatedIdentityCredentials"), Optional.empty());
    }

    public HomeRealmDiscoveryPolicyRequest homeRealmDiscoveryPolicies(String id) {
        return new HomeRealmDiscoveryPolicyRequest(contextPath.addSegment("homeRealmDiscoveryPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public HomeRealmDiscoveryPolicyCollectionRequest homeRealmDiscoveryPolicies() {
        return new HomeRealmDiscoveryPolicyCollectionRequest(contextPath.addSegment("homeRealmDiscoveryPolicies"), Optional.empty());
    }

    public LicenseDetailsRequest licenseDetails(String id) {
        return new LicenseDetailsRequest(contextPath.addSegment("licenseDetails").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public LicenseDetailsCollectionRequest licenseDetails() {
        return new LicenseDetailsCollectionRequest(contextPath.addSegment("licenseDetails"), Optional.empty());
    }

    public DirectoryObjectRequest memberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("memberOf").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest memberOf() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("memberOf"), Optional.empty());
    }

    public OAuth2PermissionGrantRequest oauth2PermissionGrants(String id) {
        return new OAuth2PermissionGrantRequest(contextPath.addSegment("oauth2PermissionGrants").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OAuth2PermissionGrantCollectionRequest oauth2PermissionGrants() {
        return new OAuth2PermissionGrantCollectionRequest(contextPath.addSegment("oauth2PermissionGrants"), Optional.empty());
    }

    public DirectoryObjectRequest ownedObjects(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("ownedObjects").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest ownedObjects() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("ownedObjects"), Optional.empty());
    }

    public DirectoryObjectRequest owners(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("owners").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest owners() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("owners"), Optional.empty());
    }

    public TokenIssuancePolicyRequest tokenIssuancePolicies(String id) {
        return new TokenIssuancePolicyRequest(contextPath.addSegment("tokenIssuancePolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TokenIssuancePolicyCollectionRequest tokenIssuancePolicies() {
        return new TokenIssuancePolicyCollectionRequest(contextPath.addSegment("tokenIssuancePolicies"), Optional.empty());
    }

    public TokenLifetimePolicyRequest tokenLifetimePolicies(String id) {
        return new TokenLifetimePolicyRequest(contextPath.addSegment("tokenLifetimePolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TokenLifetimePolicyCollectionRequest tokenLifetimePolicies() {
        return new TokenLifetimePolicyCollectionRequest(contextPath.addSegment("tokenLifetimePolicies"), Optional.empty());
    }

    public DirectoryObjectRequest transitiveMemberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("transitiveMemberOf").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest transitiveMemberOf() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("transitiveMemberOf"), Optional.empty());
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ServicePrincipal> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), ServicePrincipal.class, _parameters);
    }

}
