package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ServiceHealth;
import odata.msgraph.client.beta.entity.request.ServiceHealthIssueRequest;
import odata.msgraph.client.beta.entity.request.ServiceHealthRequest;

public class ServiceHealthCollectionRequest extends CollectionPageEntityRequest<ServiceHealth, ServiceHealthRequest>{

    protected ContextPath contextPath;

    public ServiceHealthCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ServiceHealth.class, cp -> new ServiceHealthRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ServiceHealthIssueRequest issues(String id) {
        return new ServiceHealthIssueRequest(contextPath.addSegment("issues").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ServiceHealthIssueCollectionRequest issues() {
        return new ServiceHealthIssueCollectionRequest(contextPath.addSegment("issues"), Optional.empty());
    }

}
