package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.SecurityBaselineState;
import odata.msgraph.client.beta.entity.request.SecurityBaselineSettingStateRequest;
import odata.msgraph.client.beta.entity.request.SecurityBaselineStateRequest;

public class SecurityBaselineStateCollectionRequest extends CollectionPageEntityRequest<SecurityBaselineState, SecurityBaselineStateRequest>{

    protected ContextPath contextPath;

    public SecurityBaselineStateCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, SecurityBaselineState.class, cp -> new SecurityBaselineStateRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SecurityBaselineSettingStateRequest settingStates(String id) {
        return new SecurityBaselineSettingStateRequest(contextPath.addSegment("settingStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SecurityBaselineSettingStateCollectionRequest settingStates() {
        return new SecurityBaselineSettingStateCollectionRequest(contextPath.addSegment("settingStates"), Optional.empty());
    }

}
