package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.SectionGroup;
import odata.msgraph.client.beta.entity.request.OnenoteSectionRequest;
import odata.msgraph.client.beta.entity.request.SectionGroupRequest;

public class SectionGroupCollectionRequest extends CollectionPageEntityRequest<SectionGroup, SectionGroupRequest>{

    protected ContextPath contextPath;

    public SectionGroupCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, SectionGroup.class, cp -> new SectionGroupRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SectionGroupRequest sectionGroups(String id) {
        return new SectionGroupRequest(contextPath.addSegment("sectionGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SectionGroupCollectionRequest sectionGroups() {
        return new SectionGroupCollectionRequest(contextPath.addSegment("sectionGroups"), Optional.empty());
    }

    public OnenoteSectionRequest sections(String id) {
        return new OnenoteSectionRequest(contextPath.addSegment("sections").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OnenoteSectionCollectionRequest sections() {
        return new OnenoteSectionCollectionRequest(contextPath.addSegment("sections"), Optional.empty());
    }

}
