package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.RoleDefinition;
import odata.msgraph.client.beta.entity.request.RoleAssignmentRequest;
import odata.msgraph.client.beta.entity.request.RoleDefinitionRequest;

public class RoleDefinitionCollectionRequest extends CollectionPageEntityRequest<RoleDefinition, RoleDefinitionRequest>{

    protected ContextPath contextPath;

    public RoleDefinitionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, RoleDefinition.class, cp -> new RoleDefinitionRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public RoleAssignmentRequest roleAssignments(String id) {
        return new RoleAssignmentRequest(contextPath.addSegment("roleAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RoleAssignmentCollectionRequest roleAssignments() {
        return new RoleAssignmentCollectionRequest(contextPath.addSegment("roleAssignments"), Optional.empty());
    }

}
