package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.GroupPrintUsageSummary;
import odata.msgraph.client.beta.complex.OverallPrintUsageSummary;
import odata.msgraph.client.beta.complex.PrintUsageSummary;
import odata.msgraph.client.beta.complex.PrinterUsageSummary;
import odata.msgraph.client.beta.complex.UserPrintUsageSummary;
import odata.msgraph.client.beta.entity.ReportRoot;
import odata.msgraph.client.beta.entity.request.ApplicationSignInDetailedSummaryRequest;
import odata.msgraph.client.beta.entity.request.CredentialUserRegistrationDetailsRequest;
import odata.msgraph.client.beta.entity.request.PrintUsageByPrinterRequest;
import odata.msgraph.client.beta.entity.request.PrintUsageByUserRequest;
import odata.msgraph.client.beta.entity.request.ReportRootRequest;
import odata.msgraph.client.beta.entity.request.UserCredentialUsageDetailsRequest;

public class ReportRootCollectionRequest extends CollectionPageEntityRequest<ReportRoot, ReportRootRequest>{

    protected ContextPath contextPath;

    public ReportRootCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ReportRoot.class, cp -> new ReportRootRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ApplicationSignInDetailedSummaryRequest applicationSignInDetailedSummary(String id) {
        return new ApplicationSignInDetailedSummaryRequest(contextPath.addSegment("applicationSignInDetailedSummary").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ApplicationSignInDetailedSummaryCollectionRequest applicationSignInDetailedSummary() {
        return new ApplicationSignInDetailedSummaryCollectionRequest(contextPath.addSegment("applicationSignInDetailedSummary"), Optional.empty());
    }

    public CredentialUserRegistrationDetailsRequest credentialUserRegistrationDetails(String id) {
        return new CredentialUserRegistrationDetailsRequest(contextPath.addSegment("credentialUserRegistrationDetails").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CredentialUserRegistrationDetailsCollectionRequest credentialUserRegistrationDetails() {
        return new CredentialUserRegistrationDetailsCollectionRequest(contextPath.addSegment("credentialUserRegistrationDetails"), Optional.empty());
    }

    public UserCredentialUsageDetailsRequest userCredentialUsageDetails(String id) {
        return new UserCredentialUsageDetailsRequest(contextPath.addSegment("userCredentialUsageDetails").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserCredentialUsageDetailsCollectionRequest userCredentialUsageDetails() {
        return new UserCredentialUsageDetailsCollectionRequest(contextPath.addSegment("userCredentialUsageDetails"), Optional.empty());
    }

    public PrintUsageByPrinterRequest dailyPrintUsageByPrinter(String id) {
        return new PrintUsageByPrinterRequest(contextPath.addSegment("dailyPrintUsageByPrinter").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintUsageByPrinterCollectionRequest dailyPrintUsageByPrinter() {
        return new PrintUsageByPrinterCollectionRequest(contextPath.addSegment("dailyPrintUsageByPrinter"), Optional.empty());
    }

    public PrintUsageByUserRequest dailyPrintUsageByUser(String id) {
        return new PrintUsageByUserRequest(contextPath.addSegment("dailyPrintUsageByUser").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintUsageByUserCollectionRequest dailyPrintUsageByUser() {
        return new PrintUsageByUserCollectionRequest(contextPath.addSegment("dailyPrintUsageByUser"), Optional.empty());
    }

    public PrintUsageByPrinterRequest dailyPrintUsageSummariesByPrinter(String id) {
        return new PrintUsageByPrinterRequest(contextPath.addSegment("dailyPrintUsageSummariesByPrinter").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintUsageByPrinterCollectionRequest dailyPrintUsageSummariesByPrinter() {
        return new PrintUsageByPrinterCollectionRequest(contextPath.addSegment("dailyPrintUsageSummariesByPrinter"), Optional.empty());
    }

    public PrintUsageByUserRequest dailyPrintUsageSummariesByUser(String id) {
        return new PrintUsageByUserRequest(contextPath.addSegment("dailyPrintUsageSummariesByUser").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintUsageByUserCollectionRequest dailyPrintUsageSummariesByUser() {
        return new PrintUsageByUserCollectionRequest(contextPath.addSegment("dailyPrintUsageSummariesByUser"), Optional.empty());
    }

    public PrintUsageByPrinterRequest monthlyPrintUsageByPrinter(String id) {
        return new PrintUsageByPrinterRequest(contextPath.addSegment("monthlyPrintUsageByPrinter").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintUsageByPrinterCollectionRequest monthlyPrintUsageByPrinter() {
        return new PrintUsageByPrinterCollectionRequest(contextPath.addSegment("monthlyPrintUsageByPrinter"), Optional.empty());
    }

    public PrintUsageByUserRequest monthlyPrintUsageByUser(String id) {
        return new PrintUsageByUserRequest(contextPath.addSegment("monthlyPrintUsageByUser").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintUsageByUserCollectionRequest monthlyPrintUsageByUser() {
        return new PrintUsageByUserCollectionRequest(contextPath.addSegment("monthlyPrintUsageByUser"), Optional.empty());
    }

    public PrintUsageByPrinterRequest monthlyPrintUsageSummariesByPrinter(String id) {
        return new PrintUsageByPrinterRequest(contextPath.addSegment("monthlyPrintUsageSummariesByPrinter").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintUsageByPrinterCollectionRequest monthlyPrintUsageSummariesByPrinter() {
        return new PrintUsageByPrinterCollectionRequest(contextPath.addSegment("monthlyPrintUsageSummariesByPrinter"), Optional.empty());
    }

    public PrintUsageByUserRequest monthlyPrintUsageSummariesByUser(String id) {
        return new PrintUsageByUserRequest(contextPath.addSegment("monthlyPrintUsageSummariesByUser").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintUsageByUserCollectionRequest monthlyPrintUsageSummariesByUser() {
        return new PrintUsageByUserCollectionRequest(contextPath.addSegment("monthlyPrintUsageSummariesByUser"), Optional.empty());
    }

    @Function(name = "getGroupPrintUsageSummary")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<GroupPrintUsageSummary> getGroupPrintUsageSummary(String groupId, OffsetDateTime periodStart, OffsetDateTime periodEnd) {
        Preconditions.checkNotNull(groupId, "groupId cannot be null");
        Preconditions.checkNotNull(periodStart, "periodStart cannot be null");
        Preconditions.checkNotNull(periodEnd, "periodEnd cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("groupId", "Edm.String", Checks.checkIsAscii(groupId))
            .put("periodStart", "Edm.DateTimeOffset", periodStart)
            .put("periodEnd", "Edm.DateTimeOffset", periodEnd)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<GroupPrintUsageSummary>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getGroupPrintUsageSummary"), GroupPrintUsageSummary.class, _parameters);
    }

    @Function(name = "getOverallPrintUsageSummary")
    @JsonIgnore
    public CollectionPageNonEntityRequest<OverallPrintUsageSummary> getOverallPrintUsageSummary(OffsetDateTime periodStart, OffsetDateTime periodEnd, Integer topListsSize) {
        Preconditions.checkNotNull(periodStart, "periodStart cannot be null");
        Preconditions.checkNotNull(periodEnd, "periodEnd cannot be null");
        Preconditions.checkNotNull(topListsSize, "topListsSize cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("periodStart", "Edm.DateTimeOffset", periodStart)
            .put("periodEnd", "Edm.DateTimeOffset", periodEnd)
            .put("topListsSize", "Edm.Int32", topListsSize)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOverallPrintUsageSummary"), OverallPrintUsageSummary.class, _parameters);
    }

    @Function(name = "getPrinterUsageSummary")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<PrinterUsageSummary> getPrinterUsageSummary(String printerId, OffsetDateTime periodStart, OffsetDateTime periodEnd) {
        Preconditions.checkNotNull(printerId, "printerId cannot be null");
        Preconditions.checkNotNull(periodStart, "periodStart cannot be null");
        Preconditions.checkNotNull(periodEnd, "periodEnd cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("printerId", "Edm.String", Checks.checkIsAscii(printerId))
            .put("periodStart", "Edm.DateTimeOffset", periodStart)
            .put("periodEnd", "Edm.DateTimeOffset", periodEnd)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<PrinterUsageSummary>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPrinterUsageSummary"), PrinterUsageSummary.class, _parameters);
    }

    @Function(name = "getPrintUsageSummariesByGroup")
    @JsonIgnore
    public CollectionPageNonEntityRequest<GroupPrintUsageSummary> getPrintUsageSummariesByGroup(OffsetDateTime periodStart, OffsetDateTime periodEnd) {
        Preconditions.checkNotNull(periodStart, "periodStart cannot be null");
        Preconditions.checkNotNull(periodEnd, "periodEnd cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("periodStart", "Edm.DateTimeOffset", periodStart)
            .put("periodEnd", "Edm.DateTimeOffset", periodEnd)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPrintUsageSummariesByGroup"), GroupPrintUsageSummary.class, _parameters);
    }

    @Function(name = "getPrintUsageSummariesByPrinter")
    @JsonIgnore
    public CollectionPageNonEntityRequest<PrinterUsageSummary> getPrintUsageSummariesByPrinter(OffsetDateTime periodStart, OffsetDateTime periodEnd) {
        Preconditions.checkNotNull(periodStart, "periodStart cannot be null");
        Preconditions.checkNotNull(periodEnd, "periodEnd cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("periodStart", "Edm.DateTimeOffset", periodStart)
            .put("periodEnd", "Edm.DateTimeOffset", periodEnd)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPrintUsageSummariesByPrinter"), PrinterUsageSummary.class, _parameters);
    }

    @Function(name = "getPrintUsageSummariesByTimeSpan")
    @JsonIgnore
    public CollectionPageNonEntityRequest<PrintUsageSummary> getPrintUsageSummariesByTimeSpan(OffsetDateTime periodStart, OffsetDateTime periodEnd, Integer timeSpanInMinutes) {
        Preconditions.checkNotNull(periodStart, "periodStart cannot be null");
        Preconditions.checkNotNull(periodEnd, "periodEnd cannot be null");
        Preconditions.checkNotNull(timeSpanInMinutes, "timeSpanInMinutes cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("periodStart", "Edm.DateTimeOffset", periodStart)
            .put("periodEnd", "Edm.DateTimeOffset", periodEnd)
            .put("timeSpanInMinutes", "Edm.Int32", timeSpanInMinutes)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPrintUsageSummariesByTimeSpan"), PrintUsageSummary.class, _parameters);
    }

    @Function(name = "getPrintUsageSummariesByUser")
    @JsonIgnore
    public CollectionPageNonEntityRequest<UserPrintUsageSummary> getPrintUsageSummariesByUser(OffsetDateTime periodStart, OffsetDateTime periodEnd) {
        Preconditions.checkNotNull(periodStart, "periodStart cannot be null");
        Preconditions.checkNotNull(periodEnd, "periodEnd cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("periodStart", "Edm.DateTimeOffset", periodStart)
            .put("periodEnd", "Edm.DateTimeOffset", periodEnd)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPrintUsageSummariesByUser"), UserPrintUsageSummary.class, _parameters);
    }

    @Function(name = "getUserPrintUsageSummary")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<UserPrintUsageSummary> getUserPrintUsageSummary(String userId, OffsetDateTime periodStart, OffsetDateTime periodEnd) {
        Preconditions.checkNotNull(userId, "userId cannot be null");
        Preconditions.checkNotNull(periodStart, "periodStart cannot be null");
        Preconditions.checkNotNull(periodEnd, "periodEnd cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userId", "Edm.String", Checks.checkIsAscii(userId))
            .put("periodStart", "Edm.DateTimeOffset", periodStart)
            .put("periodEnd", "Edm.DateTimeOffset", periodEnd)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<UserPrintUsageSummary>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getUserPrintUsageSummary"), UserPrintUsageSummary.class, _parameters);
    }

}
